/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: User_xxx.c $:

  Description:
    USER implemented functions called by the netXTransport Toolkit.

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2013-02-13  initial version

**************************************************************************************/

/****************************************************************************/
/*! \file User_xxx.c
    Function which must be implemented by the user                          */
/****************************************************************************/

#include "netXTransport.h"
#include "HilTransportLayer.h"
#include "ConnectorAPI.h"
#include "OS_Dependent.h"

/*****************************************************************************/
/*! Print a trace message from netXtransport toolkit
*     \param ptDevInstance  Device instance the trace is coming from
*     \param ulTraceLevel   see TRACE_LVL_XXX defines
*     \param szFormat       printf style format string
*     \param ...            printf arguments                                 */
/*****************************************************************************/
void USER_Trace(NETX_TRANSPORT_DATA_T* ptnetXTransportInst, uint32_t ulTraceLevel, char* szFormat, ...)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
  UNREFERENCED_PARAMETER( ulTraceLevel);
  UNREFERENCED_PARAMETER( szFormat);

}

/*****************************************************************************/
/*! Initialize trace
*     \param ptnetXTransportInst Pointer to netXTransport instance           */
/*****************************************************************************/
void USER_TraceInitialize(NETX_TRANSPORT_DATA_T* ptnetXTransportInst)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
}

/*****************************************************************************/
/*! De-initialize trace
*     \param ptnetXTransportInst Pointer to netXTransport instance           */
/*****************************************************************************/
void USER_TraceDeInitialize(NETX_TRANSPORT_DATA_T* ptnetXTransportInst)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
}

/*****************************************************************************/
/*! Function retrieves connector specific timeout
*     \param ptConnector  Pointer to connector
*     \param ptConnector  Pointer to returned timeout
/*****************************************************************************/
void USER_GetConnectorTimeout( PNETX_CONNECTOR_T ptConnector, uint32_t* pulTimeout)
{
  UNREFERENCED_PARAMETER( ptConnector);
  UNREFERENCED_PARAMETER( pulTimeout);
}
